/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.Formatter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;

public class PropertyDefinition {
    private final String name;
    private final PropertyType type;
    private final String label;
    private final String description;
    private final Class<? extends Propertized> effectivity;
    private final boolean visible;
    public static final BiMap<Class<? extends Propertized>, String> PROPERTY_EFFECTIVITY_NAMES;

    public PropertyDefinition(@Nonnull String name, @Nonnull PropertyType type, @Nonnull String label, @Nonnull String description, @Nonnull Class<? extends Propertized> effectivity, boolean visible) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(label);
        Preconditions.checkNotNull(description);
        Preconditions.checkNotNull(effectivity);
        this.name = name;
        this.type = type;
        this.label = label;
        this.description = description;
        this.effectivity = effectivity;
        this.visible = visible;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public PropertyType getType() {
        return this.type;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Class<? extends Propertized> getEffectivity() {
        return this.effectivity;
    }

    public boolean isImportant() {
        return this.getName().startsWith("!");
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyDefinition)) {
            return false;
        }
        PropertyDefinition that = (PropertyDefinition)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return "PropertyDefinition{name='" + this.name + "', type=" + this.type + ", label='" + this.label + "', description='" + this.description + "', effectivity=" + this.effectivity + "}";
    }

    static {
        ImmutableBiMap.Builder bob = ImmutableBiMap.builder();
        bob.put(GeneralizedOrderRequest.class, "gor");
        bob.put(GeneralizedActionRequest.class, "gar");
        bob.put(SupplyRequest.class, "sr");
        bob.put(CustomerRequest.class, "cr");
        bob.put(Material.class, "material");
        bob.put(Product.class, "product");
        bob.put(Workplace.class, "workplace");
        bob.put(RebuildType.class, "rt");
        bob.put(Action.class, "action");
        bob.put(CumulativeAction.class, "cumact");
        PROPERTY_EFFECTIVITY_NAMES = bob.build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PropertyType {
        LONG((Class)Long.class){

            @Override
            public Object toTypeValue(String s2) {
                return Formatter.parseExcelLong(s2);
            }
        }
        ,
        DOUBLE((Class)Double.class){

            @Override
            public Object toTypeValue(String s2) {
                return Formatter.parseExcelDouble(s2);
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public Object toTypeValue(String s2) {
                return s2;
            }
        }
        ,
        DATETIME((Class)Long.class){

            @Override
            public Object toTypeValue(String s2) {
                int len = s2.length();
                if (len >= 17 && s2.charAt(4) == '-') {
                    char offsetSep = s2.charAt(len - 3);
                    char offsetSep2 = s2.charAt(len - 6);
                    if (offsetSep == '+' || offsetSep == '-' || offsetSep2 == '+' || offsetSep2 == '-') {
                        return ZonedDateTime.parse(s2, ZONED_DT).toInstant().toEpochMilli();
                    }
                    return LocalDateTime.parse(s2, LOCAL_DT).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                }
                return Formatter.parseExcelLong(s2);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class){

            @Override
            public Object toTypeValue(String s2) {
                return Boolean.valueOf(s2);
            }
        }
        ,
        DURATION((Class)Long.class){

            @Override
            public Object toTypeValue(String s2) {
                return Formatter.parseExcelLong(s2);
            }
        };

        private static final DateTimeFormatter LOCAL_DT;
        private static final DateTimeFormatter ZONED_DT;
        private final Class<?> valueClass;

        private PropertyType(Class<?> valueClass) {
            this.valueClass = valueClass;
        }

        abstract Object toTypeValue(String var1);

        public Object toValue(String s2) {
            try {
                return this.toTypeValue(s2);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Conversion of value \"" + s2 + "\" to type " + this.name() + " failed.");
            }
        }

        public String asString(Object value) {
            return value.toString();
        }

        public final Class<?> getValueClass() {
            return this.valueClass;
        }

        static {
            LOCAL_DT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 19, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().toFormatter();
            ZONED_DT = new DateTimeFormatterBuilder().append(LOCAL_DT).appendOffset("+HH:mm", "+00").toFormatter();
        }
    }
}

